# 提示词库结构与 Excel 互转规范

> 本规范用于约束“提示词库”在文件系统与 Excel 之间的一致结构、命名与转换规则，确保后期自动化同步、增量更新与团队协作的稳定性。

## 1. 目录结构（约定）

```
prompt-library/
├── prompts/                          # 核心输出目录
│   ├── <工作表名称-已净化>/           # 每个 Excel 子表对应一个文件夹
│   │   ├── (行,列)_标题.md           # 单元格 → 单文件（仅包含提示词文本）
│   │   └── index.md                  # 该表分类索引（自动生成）
│   └── index.json                    # 全局 JSON 索引（自动生成）
├── docs/
│   ├── tools.md                      # 工具/链接（从表自动提取）
│   ├── support.md                    # 支持/钱包地址（从表自动提取）
│   ├── excel-data.md                 # Excel 原始数据快照（自动生成）
│   └── STRUCTURE_AND_CONVERSION_SPEC.md  # 本规范
└── scripts/
    ├── convert_local.py              # Excel ↔ 文件 的本地转换器（实现 Excel→文件）
    ├── config.yaml                   # 可选配置（数据源/策略）
    └── requirements.txt              # 依赖
```

- 只允许在 `prompts/<工作表名称-已净化>/` 下新增/修改提示词文件，其它自动文件（如 `index.md`、`index.json`）由转换器生成，禁止手改。

## 2. 命名与净化（Sanitization）

- 工作表文件夹名：对原始 Excel 工作表名称执行净化：
  - 移除非法字符：`\\ / : * ? " < > | \r \n`
  - 将空格替换为下划线 `_`
  - 最长 60 字符，超长截断
  - 示例：`"学习 提示词/1?"` → `"学习_提示词1"`
- 提示词文件名：`(行,列)_标题.md`
  - 行、列为 1 基索引（Excel 中第 1 行/第 1 列即 1）
  - 标题来源：该行第一个非空单元格的首行文本的前若干词（用于人读），同样执行净化
  - 标题仅用于文件名可读性，回写 Excel 时忽略

## 3. 文件内容规范（强约束）

- 每个提示词文件（.md）内容必须是“对应单元格的原始文本”，末尾追加一个换行；不允许包含：
  - Markdown 标题/分隔线/元信息
  - 代码围栏（```）
  - 版本历史/导航/时间戳
- 编码：UTF-8，换行：LF

## 4. Excel → 文件 的生成规则

- 每个工作表 → `prompts/<工作表名称-已净化>/`
- 行类型判定（逐行）：
  - 提示词行：该行至少一列非空，且不属于工具/社交/钱包/警告/占位
  - 工具/链接：同行包含 `http` 且非 X/Twitter 链接 → 归档 `docs/tools.md`
  - 社交：链接中包含 `x.com`/`twitter.com` → 归档 `docs/tools.md`
  - 钱包区块：先出现“表头”（含“网络/网络名称”且含“礼貌要饭地址/钱包/地址”），其后若干行按 `(网络, 地址)` 提取 → 归档 `docs/support.md`
  - 警告：包含“广告位” → 记录为警告
  - 占位：`...`/`….`/`....` → 忽略
- 对每个提示词行：
  - 对该行每个非空列 `c` 生成：`(r,c)_标题.md`，文件正文 = 单元格纯文本
- 自动索引：
  - `prompts/<表>/index.md`：统计、列表与版本矩阵（供浏览用，自动生成）
  - `prompts/index.json`：全局结构化索引，含各表、各行版本与外部资源（自动生成）
  - `docs/excel-data.md`：各表数据快照（截取前 3 列），便于审计

## 5. 文件 → Excel 的回写规则（规范定义，供实现）

> 说明：当前脚本已实现 Excel→文件；本节定义未来“文件→Excel”时的规范，以便实现反向同步器保持一致性。

- 工作表名：优先使用 `prompts/index.json` 中的 `categories[].name` 作为原始工作表名；若缺失，采用文件夹名将 `_` 还原为空格（尽力而为）。
- 单元格位置：
  - 解析文件名 `(r,c)_标题.md` 得到 1 基 `r,c`，写入 Excel 的第 `r` 行、第 `c` 列
  - 标题部分忽略，仅用于文件名可读
- 写入值：文件全文（去掉末尾多余空行）即单元格值
- 缺表/缺行列：自动创建工作表、扩展行列
- 冲突：同一 `(r,c)` 出现多文件时应失败并报告（推荐），或采用“最后写入覆盖”（需在实现中明确开关）
- 非提示词文档：`tools.md`、`support.md` 不默认回写；如需回写，应定义目标工作表名称与行布局（建议启用配置项）

## 6. 变更与校验

- 合法性检查：
  - 文件名需符合正则：`^\(\d+,\d+\)_.+\.md$`
  - 内容不得包含本规范禁止的附加信息（元信息、代码围栏等）
- 冲突检测：同一 `(r,c)` 不允许多次定义
- 兼容性：文件夹名与表名的映射以 `index.json` 为准；直接根据文件夹名还原可能出偏差

## 7. 自动化工具与用法

- 依赖安装：
  ```bash
  python3 -m pip install -r prompt-library/scripts/requirements.txt
  ```
- 运行（Excel→文件）：
  ```bash
  python3 "prompt-library/scripts/convert_local.py" \
    --excel "prompt (2).xlsx"
  ```
- 行为摘要：
  - 为每个工作表生成一个同名（净化后）目录
  - 为每个非空单元格生成一个 `.md` 文件（仅含单元格文本）
  - 重新生成所有索引与快照文档

## 8. 新增提示词（两种路径）

- 在 Excel 中新增：
  - 在目标工作表的目标行、列填写文本
  - 运行转换脚本，生成对应 `(行,列)_标题.md`
- 在文件系统中新增：
  - 到 `prompts/<工作表名称-已净化>/` 新建符合命名规范的文件
  - 文件正文仅填写提示词文本
  - 将在“文件→Excel”实现后由反向同步器写回相应 `(行,列)`

## 9. 设计取舍（Why）

- 只在提示词文件中保留“纯内容”，避免元信息造成噪声与二义性，便于复制/拼接/训练
- 元信息、导航、统计统一由自动化生成到索引与文档中，降低手工维护成本
- 以 `(行,列)` 作为跨介质的“主键”，确保 Excel 与文件的可逆映射

## 10. 版本与扩展

- 建议在 `scripts/config.yaml` 中引入可选项：
  - 反向同步开关与目标工作表名策略
  - 冲突策略（报错/覆盖）
  - 过滤器（忽略某些行/列/关键词）
- 未来可扩展：GitHub Actions/CI 校验规范合规性；支持更多字段映射（如 tag、语言）。

---

本规范适用于本仓库的所有提示词数据。如需调整，请在 PR 中同步更新 `docs/STRUCTURE_AND_CONVERSION_SPEC.md` 并说明向后兼容策略。